import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

@ExtendWith(MockitoExtension.class)
public class MockTriangleTest {

    //Define mock
    @Mock
    Triangle mockTriangle;

    @Test
    public void MyFirstMockitoTest() {
        //Triangle triangle = new Triangle(3,4,5);

        Triangle mockTriangleTest = Mockito.mock(Triangle.class);
        Triangle mockTriangleTest2 = Mockito.mock(Triangle.class, Mockito.withSettings().useConstructor(3,4,5));

        //Define behavior
        when(mockTriangleTest2.isIsosceles()).thenReturn(true);
        when(mockTriangleTest2.getArea()).thenReturn(20.0);
        when(mockTriangleTest2.getPerimeter()).thenReturn(10);

        boolean isIsoscelesResult = mockTriangleTest2.isIsosceles();
        double getAreaResult = mockTriangle.getArea();
        double getPerimeterResult = mockTriangle.getPerimeter();

        //én szoftveremben csinálok valamit a 20.0-s eredményeddel

        Assertions.assertEquals(20.0, getAreaResult);
        verify(mockTriangle).isIsosceles();

        //Assertions.assertEquals(15, getPerimeterResult);
    }
}
